/*
 *
 *    soniK digital audio editor
 *    Copyright (C) 2003-2004, 2006  Robert Walker <rob@tenfoot.org.uk>
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#ifndef SONIK_AUDIO_IO_MANAGER_H
#define SONIK_AUDIO_IO_MANAGER_H

#include <qobject.h>

#include <sonik/types.h>

namespace Sonik
{
  class Data;
  class View;
  class AudioIO;

  class AudioIOManager : public QObject
  {
    Q_OBJECT
  public:
    enum State { kIdle, kPlaying, kRecording, kPaused };

    AudioIOManager(Data& data);
    virtual ~AudioIOManager();

    IOResult open(AudioIO* device);
    void close();

    void setRange(off_t start, size_t length);
    off_t rangeStart() const;
    size_t rangeLength() const;

    State state() const;
    void play(bool loop);
    void record();
    void pause();
    void stop();

    off_t position() const;
    void  seek(off_t pos);
    void  skip(off_t delta);

    void pull(size_t length, SampleBuffer& data);
    void pull(size_t length, Sample8Buffer& data);
    void pull(size_t length, Sample16Buffer& data);
    void pull(size_t length, Sample24Buffer& data);

    void push(SampleBuffer& data);
    void push(Sample8Buffer& data);
    void push(Sample16Buffer& data);
    void push(Sample24Buffer& data);

    Data& data();

  signals:
    void playing();
    void recording();
    void paused();
    void stopped();
    void position(off_t pos);

  protected slots:
    void update();

  private:
    class Private;

    Private* d;
  };
}

#endif // SONIK_AUDIO_IO_MANAGER_H
