/*
 *
 *    soniK digital audio editor
 *    Copyright (C) 2005, 2006  Robert Walker <rob@tenfoot.org.uk>
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#ifndef SONIK_EDIT_APPLY_DIALOG_H
#define SONIK_EDIT_APPLY_DIALOG_H

#include <sonik/edit.h>

#include <qdialog.h>

// class EditApplyDialogBase;
class QFrame;
class QComboBox;

namespace Sonik
{
  class PresetManager;

  class EditApplyDialog : public QDialog
  {
    Q_OBJECT
  public:
    EditApplyDialog(Edit::PluginContext* context,
                    Edit::PresetManager* presetManager,
                    QWidget* parent=0, const char* name=0);
    virtual ~EditApplyDialog();

  public slots:
    virtual void setWidget(QWidget* w);
    virtual void releaseWidget();

    virtual void accept();

    void presetChanged(int index);
    bool presetSave();

  signals:
    void applyPlugin(Sonik::Edit::PluginContext* context);

  private:
    void createUi();

    Edit::PluginContext* mContext;
    Edit::PresetManager* mPresetManager;
    QStringList          mPresetNames;

    QWidget*             mWidget;
    QFrame*              mPluginFrame;
    QComboBox*           mPreset;
   };
}

#endif // SONIK_EDIT_APPLY_DIALOG_H
