/*
 *
 *    soniK digital audio editor
 *    Copyright (C) 2003-2004, 2006  Robert Walker <rob@tenfoot.org.uk>
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#ifndef SONIK_LIMITS_H
#define SONIK_LIMITS_H

namespace Sonik
{
  // Sample format ranges
  template <typename T> struct SampleRange
  {
    static const int   min()    { return 0; }
    static const int   max()    { return 0; }
    static const float range()  { return 0.0f; }
  };

  template<> struct SampleRange<Sample>
  {
    static const int   min()    { return -1; }
    static const int   max()    { return 1; }
    static const float range()  { return 1.0f; }
  };

  template<> struct SampleRange<Sample8>
  {
    static const int   min()    { return -128; }
    static const int   max()    { return 127; }
    static const float range()  { return 128.0f; }
  };

  template<> struct SampleRange<Sample16>
  {
    static const int   min()    { return -32768; }
    static const int   max()    { return 32767; }
    static const float range()  { return 32768.0f; }
  };

  template<> struct SampleRange<Sample24>
  {
    static const int   min()    { return -8388608; }
    static const int   max()    { return 8388607; }
    static const float range()  { return 8388608.0f; }
  };
}

#endif // SONIK_LIMITS_H
