/*
 *
 *    soniK digital audio editor
 *    Copyright (C) 2003-2004, 2006  Robert Walker <rob@tenfoot.org.uk>
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#ifndef SONIK_WAVE_WIDGET_H
#define SONIK_WAVE_WIDGET_H

#include <qwidget.h>

#include <sonik/types.h>

namespace Sonik
{
  class Data;
  class WaveRenderer;

  class WaveWidget : public QWidget
  {
    Q_OBJECT
  public:
    static const int DISPLAY_VBORDER = 10;

    WaveWidget(const Data& data, uint8_t channel,
               QWidget* parent=0, const char* name=0);
    virtual ~WaveWidget() = 0;

    const Data& data()         { return mData; }
    uint8_t     channel()      { return mChannel; }
    int         selStart()     { return mSelStart; }
    int         selLength()    { return mSelLength; }
    int         cursorPos()    { return mCursorPos; }
    int         playbackPos()  { return mPlaybackPos; }
    int         scrollPos()    { return mScrollPos; }
    float       zoom()         { return mZoom; }

  public slots:
    void lengthChanged(size_t length);
    void dataChanged(off_t start, size_t length);

    void selectionChanged(off_t start, size_t length);
    void cursorPosChanged(off_t pos);
    void playbackPosChanged(off_t pos);

    void zoomChanged(float newZoom);
    void scrollPosChanged(int newPos);

  protected:
    enum CacheClearOp
    {
      LengthChanged,
      DataChanged,
    };

    virtual void paintEvent(QPaintEvent* e);
    virtual void render(QPainter& p, const QRect& r) = 0;
    virtual void clearCache(CacheClearOp op, off_t start, size_t length);

  private:
    const Data& mData;
    uint8_t     mChannel;

    off_t       mSelStart;
    size_t      mSelLength;
    off_t       mCursorPos;
    off_t       mPlaybackPos;
    off_t       mScrollPos;
    float       mZoom;
  };
}

#endif // SONIK_WAVE_WIDGET_H
