/*
 *
 *    Sonik digital audio editor
 *    Copyright (C) 2003-2006  Robert Walker <rob@tenfoot.org.uk>
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#include "sonik.h"

#include <kuniqueapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kdebug.h>

#include <arts/kartsdispatcher.h>

#include <qtimer.h>

#include <unistd.h>

static const char *description = I18N_NOOP("soniK Audio Editor");

static const char *copyright = "(c) 2002-2006 Rob Walker";
static const char *version = "v1.0.0";

static KCmdLineOptions options[] =
{
  { "+[URL]", I18N_NOOP( "Document to open." ), 0 },
  { 0, 0, 0 }
};

int main(int argc, char **argv)
{
  KAboutData about("sonik", I18N_NOOP("soniK"), version,
                   description, KAboutData::License_GPL,
                   copyright, 0, 0, "sonik-bugs@tenfoot.org.uk");
  about.addAuthor("Rob Walker", 0, "rob@tenfoot.org.uk");
  KCmdLineArgs::init(argc, argv, &about);
  KCmdLineArgs::addCmdLineOptions( options );
  KUniqueApplication::addCmdLineOptions();

  if (!KUniqueApplication::start())
    return 0;

  KUniqueApplication app;

  // see if we are starting with session management
  if (app.isRestored())
    RESTORE(Sonik::SonikApp)
  else
  {
    // no session.. just start up normally
    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

    if ( args->count() == 0 )
    {
      Sonik::SonikApp *widget = new Sonik::SonikApp;

      widget->show();
      QTimer::singleShot(0, widget, SLOT(startupAction()));
    }
    else
    {
      int i = 0;
      for (; i < args->count(); i++ )
      {
        Sonik::SonikApp *widget = new Sonik::SonikApp;
        widget->show();
        widget->load( args->url( i ) );
      }
    }
    args->clear();
  }

  return app.exec();
}
