/*
 *
 *    Sonik digital audio editor
 *    Copyright (C) 2003-2005  Robert Walker <rob@tenfoot.org.uk>
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#ifndef SONIK_SONIK_H
#define SONIK_SONIK_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "sonikIface.h"
#include "sonik_types.h"

#include <kapplication.h>
#include <kparts/mainwindow.h>

class KAction;
class KToggleAction;
class KRecentFilesAction;

namespace Sonik
{
  class Part;

  class SonikApp : public KParts::MainWindow,
                   virtual public SonikDCOPIface
  {
    Q_OBJECT
  public:
    static const int kStatusMessage = 1;
    static const int kStateCursorPos = 2;
    static const int kStateSelection = 3;
    static const int kStateLength = 4;
    static const int kStateSampleRate = 5;
    static const int kStateBits = 6;

    /**
     * Default Constructor
     */
    SonikApp();

    /**
     * Default Destructor
     */
    virtual ~SonikApp();

    /**
     * Use this method to load whatever file/URL you have
     */
    void load(const KURL& url);


    QSize sizeHint() const;

    // DCOP functions
  public:
    virtual void openURL(const QString &name=0);
    virtual void newFile();

  protected:
    /**
     * This method is called when it is time for the app to save its
     * properties for session management purposes.
     */
    void saveProperties(KConfig *);

    /**
     * This method is called when this app is restored.  The KConfig
     * object points to the session management config file that was saved
     * with @ref saveProperties
     */
    void readProperties(KConfig *);

    virtual bool queryExit();
    virtual bool queryClose();

    void saveConfig(KConfig *);
    void readConfig(KConfig *);

  public slots:
    void startupAction();
    void loadSettings();

  private slots:
    void fileNew();
    void fileOpen();
    void fileOpenRecent(const KURL& url);

    void optionsShowToolbar();
    void optionsShowStatusbar();
    void optionsConfigure();
    void optionsConfigureKeys();
    void optionsConfigureToolbars();

    void applyNewToolbarConfig();

    void urlChanged(KURL& url);

    void statusChannelsChanged(uint8_t channels);
    void statusLengthChanged(size_t length);
    void statusSampleRateChanged(uint32_t sampleRate);
    void statusBitsChanged(uint8_t bits);
    void statusCursorPosChanged(off_t pos);
    void statusSelectionChanged(off_t start, size_t length);
    void statusTimeFormatChanged(Sonik::TimeFormat);

    void playing();
    void stopped();

  private:
    void setupActions();
    void setupStatusbar();

    int chooseStartupAction(QString& file);
    bool initNewFile();

    Sonik::Part*        mPart;

    KAction*            mFileNew;
    KAction*            mFileOpen;
    KRecentFilesAction* mFileOpenRecent;
    KAction*            mFileClose;
    KAction*            mFileQuit;

    KToggleAction*      mSettingsToolbarAction;
    KToggleAction*      mSettingsStatusbarAction;

    QString             mFileFilter;
  };
}

#endif // SONIK_SONIK_H
