/*
 *
 *    soniK digital audio editor
 *    Copyright (C) 2003-2006  Robert Walker <rob@tenfoot.org.uk>
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#include "startdlgimpl.h"

#include <qradiobutton.h>

using Sonik::StartDlgImpl;

StartDlgImpl::StartDlgImpl(QWidget *parent, const char *name,
                           bool modal, WFlags fl)
  : StartDlg(parent,name, modal, fl)
{
}

StartDlgImpl::~StartDlgImpl()
{
}

StartDlgImpl::Action StartDlgImpl::action() const
{
  if (recordNew->isChecked())
    return RecordNew;
  else if (editNew->isChecked())
    return EditNew;
  else if (openFile->isChecked())
    return OpenFile;
  else if (openRecent->isChecked())
    return OpenRecent;
  else
    return OpenFile;
}

void StartDlgImpl::setAction(StartDlgImpl::Action action)
{
  switch (action)
  {
    case RecordNew:
      recordNew->setChecked(true);
      break;
    case EditNew:
      editNew->setChecked(true);
      break;
    case OpenFile:
      openFile->setChecked(true);
      break;
    case OpenRecent:
      openRecent->setChecked(true);
      break;
    default:
      break;
  }
}
