/*
 *
 *    soniK digital audio editor
 *    Copyright (C) 2003-2004, 2006  Robert Walker <rob@tenfoot.org.uk>
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#include "sonik_complex.h"

std::ostream& Sonik::operator<<(std::ostream& o, const Sonik::ComplexSample& s)
{
  o << s.real << "+" << s.imag << "i";
  return o;
}

QTextStream& Sonik::operator<<(QTextStream& o, const Sonik::ComplexSample& s)
{
  o << s.real << "+" << s.imag << "i";
  return o;
}

using Sonik::ComplexSampleBuffer;

void ComplexSampleBuffer::real(Sonik::SampleBuffer& buf) const
{
  size_t l = size();
  buf.resize(l);
  const ComplexSample* p = data();
  Sample* r = buf.data();

  while (l--)
    *r++ = (p++)->real;
}

void ComplexSampleBuffer::imag(Sonik::SampleBuffer& buf) const
{
  size_t l = size();
  buf.resize(l);
  const ComplexSample* p = data();
  Sample* r = buf.data();

  while (l--)
    *r++ = (p++)->imag;
}

void ComplexSampleBuffer::abs(Sonik::SampleBuffer& buf) const
{
  size_t l = size();
  buf.resize(l);
  const ComplexSample* p = data();
  Sample* r = buf.data();

  while (l--)
    *r++ = (p++)->abs();
}
