#!/bin/sh

#    soniK digital audio editor
#    Copyright (C) 2003-2006  Robert Walker <rob@tenfoot.org.uk>
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

. ${SONIK_SRC}/test/test.sh

OCT=/tmp/tfft.oct.$$

# sizes are powers of two and 10 random ones
SIZES=`gen_sizes 4 32768 8`

TYPES="sine zeros ones noise"

[ -d data ] || mkdir data

#
# generate data files
#
FILES=""
cat <<EOF > ${OCT}
function c = do_sine(n, f)
  x = 0:(n-1);
  w = f/n;
  c = sin(x * 2*pi * w);
endfunction
function c = do_zeros(n, f)
  c = zeros(1,n);
endfunction
function c = do_ones(n, f)
  c = ones(1,n);
endfunction
function c = do_noise(n, f)
  c = randn(1,n);
endfunction
EOF
for sz in ${SIZES}; do
  for t in ${TYPES}; do
    if [ ${t} = "sine" ]; then
      FREQS="1 10 100"
    else
      FREQS="1"
    fi
    for f in ${FREQS}; do
      #
      # generate data
      #
      o=data/tfft.${t}.${f}.${sz}.dat
      cat <<EOF >> ${OCT}
s = do_${t}(${sz}, ${f});
fd = fopen("${o}", "wb");
fwrite(fd, s, "float32");
fclose(fd);
EOF
      #
      # generate expected ffts
      #
      fft=data/tfft.${t}.${f}.${sz}.fft
      cat <<EOF >> ${OCT}
  sz = ${sz};
  fsz = sz/2 + 1;
  f = fft(s);
  a = abs(f);
  fd = fopen("${fft}", "wb");
  fwrite(fd, [ real(f(1:fsz))' imag(f(1:fsz))']', "float32");
  fwrite(fd, a(1:fsz), "float32");
  fclose(fd);
EOF
      FILES="${FILES} ${o}"
    done
  done
done
octave -q ${OCT}

rm ${OCT}

echo ${SIZES} > $1
