#!/bin/sh

#    soniK digital audio editor
#    Copyright (C) 2003-2006  Robert Walker <rob@tenfoot.org.uk>
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

. ${SONIK_SRC}/test/test.sh

OCT=/tmp/twindow.oct.$$

SIZES=`gen_sizes 1 32768 10`

WINDOWS="rectangular triangular bartlett blackman chebyshev hamming hann kaiser"

[ -d data ] || mkdir data

#
# generate windowing functions
#
cat <<EOF > ${OCT}
function c = do_rectangular(n)
  c = ones(n, 1);
endfunction
function c = do_triangular(n)
  c = 1 - abs ([-(n-1):2:(n-1)]' / (n+rem(n,2)));
endfunction
function c = do_bartlett(m)
  if (! (is_scalar (m) && (m == round (m)) && (m > 0)))
    error ("bartlett: m has to be an integer > 0");
  endif
  if (m == 1)
    c = 1;
  else
    m = m - 1;
    n = fix (m / 2);
    c = [2*(0:n)/m, 2-2*(n+1:m)/m]';
  endif
endfunction
function c = do_blackman(n)
  c = blackman(n);
endfunction
function c = do_chebyshev(n)
  # requires octave forge
  c = chebwin(n, 100.0);
endfunction
function c = do_hamming(n)
  c = hamming(n);
endfunction
function c = do_hann(n)
  c = hanning(n);
endfunction
function c = do_kaiser(n)
  # requires octave forge
  c = kaiser(n, 0.5);
endfunction
EOF
for w in ${WINDOWS}; do
  for sz in $SIZES; do
    f=data/twindow.${w}.${sz}.dat
cat <<EOF >> ${OCT}
exp = do_${w}(${sz});
fd = fopen("${f}", "wb");
fwrite(fd, exp, "float32");
fclose(fd);
EOF
  done
done

octave -q ${OCT}

rm ${OCT}

echo ${SIZES} > $1
