/*
 *
 *    soniK digital audio editor
 *    Copyright (C) 2004-2006  Robert Walker <rob@tenfoot.org.uk>
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#include <cppunit/extensions/HelperMacros.h>

#include <sonik_types.h>

using namespace Sonik;

class TraitsTest : public CppUnit::TestFixture
{
  CPPUNIT_TEST_SUITE( TraitsTest );
  CPPUNIT_TEST( testCastSample );
  CPPUNIT_TEST( testCastSample8 );
  CPPUNIT_TEST( testCastSample16 );
  CPPUNIT_TEST( testCastSample24 );
  CPPUNIT_TEST_SUITE_END();

public:
  void setUp()
  {
  }

  void tearDown()
  {
  }

  void testCastSample()
  {
    for (float i = -1000.0f; i < 1000.0f; i += 0.8955)
    {
      CPPUNIT_ASSERT_DOUBLES_EQUAL(i, SampleTraits<Sample>::cast(i), 0.001f);
    }
  }

  void testCastSample8()
  {
    for (int i = SampleTraits<Sample8>::min();
         i <= SampleTraits<Sample8>::max();
         ++i)
    {
      Sample x = i / SampleTraits<Sample8>::range();
      CPPUNIT_ASSERT(x >= -1.0f);
      CPPUNIT_ASSERT(x <= 1.0f);
      CPPUNIT_ASSERT_EQUAL((Sample8)i, SampleTraits<Sample8>::cast(x));
    }
  }

  void testCastSample16()
  {
    for (int i = SampleTraits<Sample16>::min();
         i <= SampleTraits<Sample16>::max();
         ++i)
    {
      Sample x = i / SampleTraits<Sample16>::range();
      CPPUNIT_ASSERT(x >= -1.0f);
      CPPUNIT_ASSERT(x <= 1.0f);
      CPPUNIT_ASSERT_EQUAL((Sample16)i, SampleTraits<Sample16>::cast(x));
    }
  }

  void testCastSample24()
  {
    for (int i = SampleTraits<Sample24>::min();
         i <= SampleTraits<Sample24>::max();
         i += 123)
    {
      Sample x = i / SampleTraits<Sample24>::range();
      CPPUNIT_ASSERT(x >= -1.0f);
      CPPUNIT_ASSERT(x <= 1.0f);
      CPPUNIT_ASSERT_EQUAL((Sample24)i, SampleTraits<Sample24>::cast(x));
    }
  }

  // TODO: performance testing
};

CPPUNIT_TEST_SUITE_REGISTRATION(TraitsTest);

// TODO: test to / from conversions (in tutil.cpp)
// TODO: test bound
// TODO: test interleave
// TODO: test time access
// TODO: test dB conv
// TODO: test sequence generator
