/*
 *
 *    soniK digital audio editor
 *    Copyright (C) 2003-2006  Robert Walker <rob@tenfoot.org.uk>
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#include "sonik_util.h"

int Sonik::timeToSamples(uint sampleRate, int h, int m, int s, int ms)
{
  // compute seconds & milli-seconds separately to avoid overflow
  return (((((h * 60) + m) * 60) + s) * sampleRate) + (ms * sampleRate) / 1000;
}

QString Sonik::toString(int t, uint sampleRate, TimeFormat format)
{
  QString str;

  switch (format) {
  case kH_M:
    str.sprintf("%.2d:%.2d", hour(t, sampleRate), minute(t, sampleRate));
    break;

  case kH_M_S:
    str.sprintf("%.2d:%.2d:%.2d", hour(t, sampleRate),
                minute(t, sampleRate), sec(t, sampleRate));
    break;

  case kH_M_S_Ms:
    str.sprintf("%.2d:%.2d:%.2d:%.3d", hour(t, sampleRate),
                minute(t, sampleRate), sec(t, sampleRate),
                msec(t, sampleRate));
    break;

  case kMs:
    str.sprintf("%d", toMSecs(t, sampleRate));
    break;

  case kSamples:
    str.sprintf("%d", t);
    break;

  case kH_M_S_FCDDA:
    str.sprintf("%.2d:%.2d:%.2d:%.2d", hour(t, sampleRate),
                minute(t, sampleRate), sec(t, sampleRate),
                CDDAFrame(t, sampleRate));
    break;

  case kH_M_S_FPAL:
    str.sprintf("%.2d:%.2d:%.2d:%.2d", hour(t, sampleRate),
                minute(t, sampleRate), sec(t, sampleRate),
                PALFrame(t, sampleRate));
    break;

  case kH_M_S_FNTSC:
    str.sprintf("%.2d:%.2d:%.2d:%.2d", hour(t, sampleRate),
                minute(t, sampleRate), sec(t, sampleRate),
                NTSCFrame(t, sampleRate));
    break;

  default:
    str = "Unknown format";
    break;
  }

  return str;
}


QString Sonik::widestFormatString(int t, uint sampleRate, TimeFormat format)
{
  QString str;

  switch (format) {
    case kH_M:
      str = "88:88";
      break;

    case kH_M_S:
      str = "88:88:88";
      break;

    case kH_M_S_Ms:
      str = "88:88:88.888";
      break;

    case kMs:
      // round up to next power of 10
      str.sprintf("%d", (int)std::pow(10, std::ceil(std::log10((double)toMSecs(t, sampleRate)))));
      break;

    case kSamples:
      // round up to next power of 10
      str.sprintf("%d", (int)std::pow(10, std::ceil(std::log10((double)t))));
      break;

    case kH_M_S_FCDDA:
    case kH_M_S_FPAL:
    case kH_M_S_FNTSC:
      str = "88:88:88.88";
      break;

    default:
      str = "Unknown format";
      break;
  }

  return str;
}
