/*
 *
 *    soniK digital audio editor
 *    Copyright (C) 2004-2006  Robert Walker <rob@tenfoot.org.uk>
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#ifndef SONIK_ACTION_MANAGER_H
#define SONIK_ACTION_MANAGER_H

#include "sonik_types.h"

#include <qobject.h>
#include <qvaluelist.h>

namespace Sonik
{
  class Data;
  class PartWidget;

  class Action
  {
  public:
    virtual ~Action();
    virtual void apply() = 0;

    QString name() const { return mName; }

    virtual QString debugPrint(int indent);

  protected:
    Action(const QString& name);

    QString mName;
  };
  typedef QValueList<Action *> ActionSequence;

  class ActionManager : public QObject
  {
    Q_OBJECT
  public:
    ActionManager();
    virtual ~ActionManager();

    void recordAction(Action *action);
    void undo();
    void redo();
    void abort();

    void setEnabled(bool enabled);

    void beginCompoundAction(const QString& name);
    void endCompoundAction();
    void abortCompoundAction();

    void clear();

  signals:
    void undoChanged(const QString& name);
    void redoChanged(const QString& name);

  private:
    enum State { DISABLED, NORMAL, UNDOING, REDOING, ABORTING };

    State                        mState;
    ActionSequence               mUndoActions;
    ActionSequence               mRedoActions;
    QValueList<ActionSequence *> mActionSequences;
  };
}


#endif // SONIK_ACTION_MANAGER_H
