/*
 *
 *    soniK digital audio editor
 *    Copyright (C) 2003-2004, 2006  Robert Walker <rob@tenfoot.org.uk>
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#include "audiodragobject.h"
#include "data.h"

using Sonik::AudioDragObject;

AudioDragObject::AudioDragObject(SampleSegment data,
                                 QWidget *dragSource, const char *name)
  : QDragObject(dragSource,name),
    mData(data)
{
}

AudioDragObject::~AudioDragObject()
{
}

const char* AudioDragObject::format (int i) const
{
  if (i == 0)
    return "audio/x-wav";
  else
    return NULL;
}

QByteArray AudioDragObject::encodedData(const char* /*fmt*/) const
{
  QByteArray res;

  return res;
}

bool AudioDragObject::canDecode(const QMimeSource* /*e*/)
{
  return false;
}

bool AudioDragObject::decode(const QMimeSource* /*e*/, QByteArray& /*dest*/)
{
  return false;
}
