/*
 *
 *    soniK digital audio editor
 *    Copyright (C) 2003-2006  Robert Walker <rob@tenfoot.org.uk>
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef SONIK_INSERTPOSITIONWIDGET_H
#define SONIK_INSERTPOSITIONWIDGET_H

#include "sonik_types.h"

#include <qwidget.h>

class QComboBox;
class KIntSpinBox;
class QTimeEdit;
class KDoubleSpinBox;

namespace Sonik
{
  class InsertPositonWidget : public QWidget
  {
    Q_OBJECT

    Q_PROPERTY( int position READ positionInt WRITE setPositionInt );
    Q_PROPERTY( double length READ lengthSecs WRITE setLengthSecs );

  public:
    InsertPositonWidget(QWidget *parent = 0, const char* name = 0);

    void setSampleRate(uint32_t sampleRate);
    void setDefaults(uint32_t sampleRate, size_t selectionLength);

    Sonik::InsertPosition position() const;
    void                  setPosition(Sonik::InsertPosition pos);

    // variants of position for use with QObject property
    int  positionInt() const;
    void setPositionInt(int pos);

    size_t length() const;
    double lengthSecs() const;
    void   setLength(size_t length);
    void   setLengthSecs(double secs);

  public slots:
    void selectionChanged(off_t start, size_t length);
    void enableReplaceSelection(bool enable);

  protected slots:
    void lengthUnitsChanged(int index);

  private:
    void createUi();
    size_t calculateLength(int units) const;

    int             mLastUnits;
    uint32_t        mSampleRate;

    QComboBox*      mPos;
    KIntSpinBox*    mLengthSamples;
    QTimeEdit*      mLengthTime;
    KDoubleSpinBox* mLengthSecs;
    QComboBox*      mLengthUnits;
  };
}

#endif // SONIK_INSERTPOSITIONWIDGET_H




