/*
 *
 *    soniK digital audio editor
 *    Copyright (C) 2006  Robert Walker <rob@tenfoot.org.uk>
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include "repeataction.h"

#include <ktoolbar.h>
#include <ktoolbarbutton.h>

using Sonik::RepeatAction;


RepeatAction::RepeatAction(const QString &text, const QString &pix,
                           const KShortcut &cut,
                           const QObject *receiver, const char *slot,
                           KActionCollection *parent, const char *name)
  : KAction(text, pix, cut, receiver, slot, parent, name)
{
}


RepeatAction::~RepeatAction()
{
}


int Sonik::RepeatAction::plug(QWidget* widget, int index)
{
  index = KAction::plug(widget, index);

  if (widget->inherits("KToolBar"))
  {
    KToolBar *bar = static_cast<KToolBar*>(widget);
    KToolBarButton *button = bar->getButton(itemId(index));

    if (button)
      button->setAutoRepeat(true);
  }

  return index;
}


