/*
 *
 *    soniK digital audio editor
 *    Copyright (C) 2003-2006  Robert Walker <rob@tenfoot.org.uk>
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#ifndef SONIK_SLIDER_H
#define SONIK_SLIDER_H

#include <qvariant.h>
#include <qwidget.h>
#include <qvaluevector.h>

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QSpinBox;
class QLabel;
class QSlider;

namespace Sonik
{
  class Slider : public QWidget
  {
    Q_OBJECT

    Q_PROPERTY( double value READ value WRITE setValue )

  public:
    Slider(const QString& labelText, double min, double max, int precision,
           double step, bool logScale, Qt::Orientation orientation,
           QWidget* parent = 0, const char* name = 0);
    virtual ~Slider();

    double value() const;
    int precision() const;

    Qt::Orientation orientation() const;
    int labelWidth() const;
    int spinBoxWidth() const;

  public slots:
    void setValue(double value);
    void setPrecision(int precision);
    void setLabelWidth(int width);
    void setSpinBoxWidth(int width);

  protected slots:
    void spinValueChanged(double value);
    void spinValueChanged(int value);
    void sliderValueChanged(int value);

  signals:
    void valueChanged(double value);

  protected:
    double sliderToVal(int s) const;
    int valToSlider(double v) const;

    virtual bool eventFilter(QObject *o, QEvent *e);

  private:
    void layoutHorizontalSlider(QLabel *minLabel,
                                QLabel *midLabel,
                                QLabel *maxLabel);
    void   layoutVerticalSlider(QLabel *minLabel,
                                QLabel *midLabel,
                                QLabel *maxLabel);

    Qt::Orientation mOrientation;
    QSlider*  mSlider;
    QSpinBox* mSpinBox;
    QLabel*   mLabel;

    bool      mLogScale;
    double    mSMin;
    double    mSRange;
  };

  typedef QValueVector<Slider *> SliderPtrVector;

  void alignHorizontalSliders(SliderPtrVector& sliders);
}


#endif // SONIK_SLIDER_H
