/*
 *
 *    soniK digital audio editor
 *    Copyright (C) 2005, 2006  Robert Walker <rob@tenfoot.org.uk>
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#include "insertpositonwidget.h"

#include <kaboutdata.h>
#include <kapplication.h>
#include <kcmdlineargs.h>

#include <qvbox.h>
#include <qscrollbar.h>

int main(int argc, char *argv[])
{
  static const int kLen = 250000;

  KAboutData about("tinsertpositionwidget",
                   I18N_NOOP("tinsertpositionwidget"), "0");
  KCmdLineArgs::init(argc, argv, &about);
  KApplication a;

  QVBox* w = new QVBox;
  Sonik::InsertPositonWidget *ip = new Sonik::InsertPositonWidget(w);
  ip->setDefaults(10000, 50000);

  a.setMainWidget(w);
  w->show();

  return a.exec();
}
