/*
 *
 *    soniK digital audio editor
 *    Copyright (C) 2003-2006  Robert Walker <rob@tenfoot.org.uk>
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#include "slider.h"

#include <kapplication.h>
#include <kcmdlineargs.h>
#include <kdebug.h>
#include <klocale.h>

#include <qhbox.h>
#include <qvbox.h>
#include <qvaluevector.h>

int main(int argc, char *argv[])
{
  KCmdLineArgs::init(argc, argv, "tslider", I18N_NOOP("tSlider"), "", "");
  KApplication a;

  QValueVector<Sonik::Slider*> sliders;

  QVBox* w = new QVBox();
  QHBox* r = new QHBox(w);
  sliders.push_back(new Sonik::Slider("lin 0 10", 0, 10, 2, 1, false, Qt::Vertical, r));
  sliders.push_back(new Sonik::Slider("lin -10 10", -10, 10, 2, 1, false, Qt::Vertical, r));
  sliders.push_back(new Sonik::Slider("lin 0 20", 0, 20, 2, 1, false, Qt::Vertical, r));
  sliders.push_back(new Sonik::Slider("lin 0 100", 0, 100, 2, 1, false, Qt::Vertical, r));
  sliders.push_back(new Sonik::Slider("lin 10 20", 10, 20, 2, 1, false, Qt::Vertical, r));

  sliders.push_back(new Sonik::Slider("log 0 10", 0, 10, 2, 1, true, Qt::Vertical, r));
  sliders.push_back(new Sonik::Slider("log 0 20", 0, 20, 2, 1, true, Qt::Vertical, r));
  sliders.push_back(new Sonik::Slider("log 0 100", 0, 100, 2, 1, true, Qt::Vertical, r));
  sliders.push_back(new Sonik::Slider("log 10 20", 10, 20, 2, 1, true, Qt::Vertical, r));

  sliders.push_back(new Sonik::Slider("p0 0 10", 0, 10, 0, 1, false, Qt::Vertical, r));
  sliders.push_back(new Sonik::Slider("p1 0 10", 0, 10, 1, 1, false, Qt::Vertical, r));
  sliders.push_back(new Sonik::Slider("p2 0 10", 0, 10, 2, 1, false, Qt::Vertical, r));
  sliders.push_back(new Sonik::Slider("p3 0 10", 0, 10, 3, 1, false, Qt::Vertical, r));

  r = new QHBox(w);
  sliders.push_back(new Sonik::Slider("lin 0 10", 0, 10, 2, 1, false, Qt::Horizontal, r));
  sliders.push_back(new Sonik::Slider("lin -10 10", -10, 10, 2, 1, false, Qt::Horizontal, r));

  r = new QHBox(w);
  sliders.push_back(new Sonik::Slider("log 0 10", 0, 10, 2, 1, true, Qt::Horizontal, r));
  sliders.push_back(new Sonik::Slider("log 0 20", 0, 20, 2, 1, true, Qt::Horizontal, r));

  sliders.push_back(new Sonik::Slider("p0 0 10", 0, 10, 0, 1, false, Qt::Horizontal, w));
  sliders.push_back(new Sonik::Slider("p1 0 10", 0, 10, 1, 1, false, Qt::Horizontal, w));
  sliders.push_back(new Sonik::Slider("p2 0 10", 0, 10, 2, 1, false, Qt::Horizontal, w));
  sliders.push_back(new Sonik::Slider("p3 0 10", 0, 10, 3, 1, false, Qt::Horizontal, w));

  // TODO: alignment test
  // TODO: split into multiple windows

  a.setMainWidget(w);
  w->show();

  QValueVector<Sonik::Slider*>::iterator s = sliders.begin();
  for ( ; s != sliders.end(); ++s)
    kdDebug(60606) << "::main: "
                   << (*s)->value()
                   << "\n";


  return a.exec();
}
