/*
 *
 *    soniK digital audio editor
 *    Copyright (C) 2005, 2006  Robert Walker <rob@tenfoot.org.uk>
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#include "valuescale.h"

#include <kapplication.h>
#include <kcmdlineargs.h>
#include <klocale.h>

#include <qhbox.h>
#include <qscrollbar.h>

int main(int argc, char *argv[])
{
  KCmdLineArgs::init(argc, argv, "tvaluescale", I18N_NOOP("tvaluescale"), "", "");
  KApplication a;

  QHBox* w = new QHBox;

  Sonik::ValueScale *vs1 = new Sonik::ValueScale(w);
  vs1->setMin(-1.0);
  vs1->setMax(1.0);
  vs1->setIsLog(false);
  vs1->setTickFormat("%.02f");
  vs1->setBorder(false);

  Sonik::ValueScale *vs2 = new Sonik::ValueScale(w);
  vs2->setMin(-32768.0);
  vs2->setMax(32767.0);
  vs2->setIsLog(false);
  vs2->setTickFormat("%.0f");
  vs2->setBorder(false);

  w->resize(w->width(), 600);
  a.setMainWidget(w);
  w->show();

  return a.exec();
}
