/*
 *
 *    soniK digital audio editor
 *    Copyright (C) 2005, 2006  Robert Walker <rob@tenfoot.org.uk>
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#include "zoom.h"

#include <kapplication.h>
#include <kcmdlineargs.h>
#include <kdebug.h>
#include <klocale.h>

#include <qlayout.h>

void addWidget(QVBoxLayout* l, QWidget* w)
{
  QHBoxLayout* l2 = new QHBoxLayout();
  l2->addWidget(w);
  l2->addStretch();
  l->addLayout(l2);
  l->addStretch();
}

int main(int argc, char *argv[])
{
  KCmdLineArgs::init(argc, argv, "tzoom", I18N_NOOP("tZoom"), "", "");
  KApplication a;

  QWidget* w = new QWidget();
  QVBoxLayout* l = new QVBoxLayout(w);

  addWidget(l, new Sonik::Zoom(-10, 10, 0, Qt::Horizontal, true, w));
  addWidget(l, new Sonik::Zoom(-10, 10, 0, Qt::Horizontal, false, w));
  addWidget(l, new Sonik::Zoom(-20, 20, 0, Qt::Horizontal, true, w));

  addWidget(l, new Sonik::Zoom(-10, 10, 0, Qt::Vertical, true, w));
  addWidget(l, new Sonik::Zoom(-10, 10, 0, Qt::Vertical, false, w));
  addWidget(l, new Sonik::Zoom(-20, 20, 0, Qt::Vertical, true, w));

  a.setMainWidget(w);
  w->show();


  return a.exec();
}
