/*
 *
 *    soniK digital audio editor
 *    Copyright (C) 2003-2006  Robert Walker <rob@tenfoot.org.uk>
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#ifndef SONIK_TIMESCALE_H
#define SONIK_TIMESCALE_H

#include "sonik_types.h"

#include <qwidget.h>
#include <qmap.h>

namespace Sonik
{
  class TimeScale : public QWidget
  {
    Q_OBJECT
  public:
    enum MarkerBound { Lower, Middle, Upper };
    enum MarkerStyle { Line, Triangle, Tee };

    TimeScale(QWidget *parent=0, const char *name=0);
    virtual ~TimeScale() { }

    void setMaxTime(uint newMax);

    TimeFormat format() { return mTimeFormat; }
    void       setFormat(TimeFormat newFormat);

    void setSampleRate(uint newSampleRate);

    void setMarker(int id, uint pos, MarkerBound bound, MarkerStyle style);
    void removeMarker(int id);

  public slots:
    void posChanged(int newPos);
    void zoomChanged(float newValue);

  protected:
    virtual void paintEvent (QPaintEvent *paintEvent);

  protected:
    struct MarkerInfo
    {
      uint        pos;
      MarkerBound bound;
      MarkerStyle style;
    };

    void calculateTickInterval();
    int markerScreenPos(const MarkerInfo& m, uint scrollPos, float zoom);

    uint                  mPos;
    uint                  mMaxTime;
    float                 mZoom;
    uint                  mSampleRate;
    TimeFormat            mTimeFormat;
    uint                  mTickInterval;
    QMap<int, MarkerInfo> mMarkers;
  };

}

#endif // SONIK_TIMESCALE_H
