/*
 *
 *    soniK digital audio editor
 *    Copyright (C) 2003-2004, 2006  Robert Walker <rob@tenfoot.org.uk>
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#ifndef SONIK_VALUESCALE_H
#define SONIK_VALUESCALE_H

#include <qwidget.h>

#include <stdint.h>

namespace Sonik
{
  class ValueScale : public QWidget
  {
    Q_OBJECT
  public:
    ValueScale(QWidget *parent=0, const char *name=0);
    virtual ~ValueScale() { }

    float min() const { return mMin; }
    void setMin(float min);

    float max() const { return mMax; }
    void setMax(float max);

    bool isLog() const { return mIsLog; }
    void setIsLog(bool isLog);

    const QString& tickFormat() const { return mTickFormat; }
    void setTickFormat(const QString& format);

    const QString& label() const { return mLabel; }
    void setLabel(const QString& label);

    uint32_t border() const { return mBorder; }
    void setBorder(uint32_t border);

    virtual QSize sizeHint() const;

  protected: // Protected methods
    virtual void paintEvent(QPaintEvent *paintEvent);
    virtual void resizeEvent (QResizeEvent *resizeEvent);
    virtual void fontChange(const QFont& oldFont);

  private:
    void     recalc();
    QString  formatTick(float tick);
    void     calcTicks();

    float    mMin;
    float    mMax;
    bool     mIsLog;
    QString  mTickFormat;
    QString  mLabel;

    uint32_t mBorder;

    QFont    mTickFont;
    QSize    mTickSize;
    float    mRange;

    uint32_t mNumTicks;

    int      mLabelHeight;
    int      mLabelAscent;
  };

}

#endif // SONIK_VALUESCALE_H
