/*
 *
 *    soniK digital audio editor
 *    Copyright (C) 2003-2006  Robert Walker <rob@tenfoot.org.uk>
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#ifndef SONIK_ZOOM_H
#define SONIK_ZOOM_H

#include <qwidget.h>

#include <stdint.h>

class QPushButton;
class QLabel;
class QTimer;
class QPaintEvent;
class QResizeEvent;

namespace Sonik
{
  class Zoom : public QWidget
  {
    Q_OBJECT
  public:

    enum ButtonState { kButtonNone, kButtonIn, kButtonOut };

    Zoom(QWidget *parent=0, const char *name=0);
    Zoom(Orientation orientation=Qt::Horizontal, bool showLabel=true,
         QWidget *parent=0, const char *name=0);
    Zoom(int minPower=0, int maxPower=0, int initPower=0,
         Orientation orientation=Qt::Horizontal, bool showLabel=true,
         QWidget *parent=0, const char *name=0);
    virtual ~Zoom();

    int  minPower(void) { return mMinPower; }
    void setMinPower(int newPow);

    int  maxPower(void) { return mMaxPower; }
    void setMaxPower(int newPow);

    int  curPower(void) { return mCurPower; }
    void setCurPower(int newPow);

    float curValue(void) { return mCurValue; }
    void  setCurValue(float newValue);

    void zoomIn();
    void zoomOut();

    virtual QSize sizeHint() const;

  signals: // Signals
    void zoomChanged(float value);

  public slots: // Public slots
    void zoomOutClicked();
    void zoomInClicked();
    void zoomInPressed();
    void zoomInReleased();
    void zoomOutPressed();
    void zoomOutReleased();
    void autoRepeat();

  protected:
    virtual void paintEvent(QPaintEvent*);
    virtual void resizeEvent(QResizeEvent*);

  private:
    void init();
    void updateLabel();

  protected:
    Qt::Orientation mOrientation;
    int             mMinPower;
    int             mMaxPower;
    int             mCurPower;
    float           mCurValue;
    bool            mShowLabel;

  private:
    QPushButton*    mZoomIn;
    QPushButton*    mZoomOut;
//     QLabel*         mLabel;
    QTimer*         mRepeatTimer;
    ButtonState     mButtonState;
    QString         mText;
  };
}

#endif // SONIK_ZOOM_H
