/*
 *
 *    soniK digital audio editor
 *    Copyright (C) 2003-2004, 2006  Robert Walker <rob@tenfoot.org.uk>
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#ifndef SONIK_DISPLAY_H
#define SONIK_DISPLAY_H

#include "plugin.h"
#include "sonik_types.h"

namespace Sonik
{
  class Data;
  class WaveWidget;

  class Display : public Plugin
  {
    Q_OBJECT
  public:
    enum VerticalAxis { kValue, kFreq };

    Display(const QString& pluginName, const QString& displayName,
            QObject* parent=0, const char* name=0,
            const QStringList& args=QStringList());
    virtual ~Display() = 0;

    void setActive(bool active);
    bool active() const;

    virtual WaveWidget* makeWidget(const Data& data,
                                   uint8_t channel,
                                   QWidget* parent = 0,
                                   const char* name = 0) const = 0;

    virtual VerticalAxis verticalAxis() const = 0;
    virtual uint32_t verticalBorder() const = 0;

  protected slots:
    void slotPluginAction();

  signals:
    void pluginSelected(Sonik::Display* plugin);

  protected:
    bool           mIsActive;
    KToggleAction* mPluginAction;
  };
}

#endif // SONIK_DISPLAY_H
