/*
 *
 *    soniK digital audio editor
 *    Copyright (C) 2003-2006  Robert Walker <rob@tenfoot.org.uk>
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#include "fileio.h"

using Sonik::FileIO;
using Sonik::FileIOFactory;

FileIO::IOBase::IOBase(const QString& fileName, const QString& mimeType,
                       size_t length, uint8_t channels,
                       uint32_t sampleRate, uint8_t bits)
  : mFileName(fileName), mMimeType(mimeType),
    mLength(length), mChannels(channels), mSampleRate(sampleRate), mBits(bits)
{
}

FileIO::IOBase::~IOBase()
{
}

FileIO::Reader::Reader(const QString& fileName, const QString& mimeType)
  : FileIO::IOBase::IOBase(fileName, mimeType, 0, 0, 1, 0)
{
}

FileIO::Reader::~Reader()
{
}

FileIO::Writer::Writer(const QString& fileName, const QString& mimeType,
                       size_t length, uint8_t channels,
                       uint32_t sampleRate, uint8_t bits)
  : FileIO::IOBase::IOBase(fileName, mimeType,
                           length, channels, sampleRate, bits)
{
}

FileIO::Writer::~Writer()
{
}


FileIO::FileIO(const QString& pluginName, const QString& displayName,
               QObject* parent, const char* name,
               const QStringList& args)
  : Plugin(pluginName, displayName, parent, name, args)
{
}

FileIO::~FileIO()
{
}

FileIOFactory::FileIOFactory()
{
}

FileIOFactory::~FileIOFactory()
{
}

void FileIOFactory::add(FileIO* f)
{
  QStringList mimeTypes = f->readMimeTypes();
  QStringList::Iterator it = mimeTypes.begin();
  for ( ; it != mimeTypes.end(); ++it)
    mReaders[*it] = f;

  mimeTypes = f->writeMimeTypes();
  it = mimeTypes.begin();
  for ( ; it != mimeTypes.end(); ++it)
    mWriters[*it] = f;
}

FileIO::Reader* FileIOFactory::makeReader(const QString& fileName,
                                          const QString& mimeType)
{
  MimeTypeMap::const_iterator it = mReaders.find(mimeType);
  if (it != mReaders.end())
    return (*it)->makeReader(fileName, mimeType);
  else
    return 0;
}

FileIO::Writer* FileIOFactory::makeWriter(const QString& fileName,
                                          const QString& mimeType,
                                          size_t length, uint8_t channels,
                                          uint32_t sampleRate, uint8_t bits)
{
  MimeTypeMap::const_iterator it = mWriters.find(mimeType);
  if (it != mWriters.end())
    return (*it)->makeWriter(fileName, mimeType,
                             length, channels, sampleRate, bits);
  else
    return 0;
}
