/*
 *
 *    soniK digital audio editor
 *    Copyright (C) 2003-2004, 2006  Robert Walker <rob@tenfoot.org.uk>
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#include "formatdialog.h"

#include "formatwidget.h"

#include <klocale.h>
#include <knuminput.h>
#include <kdebug.h>

#include <qradiobutton.h>
#include <qcombobox.h>

using Sonik::FormatDialog;

FormatDialog::FormatDialog(const Format& format,
                           QWidget *parent, const char *name)
  : KDialogBase(parent, name, true, i18n("Edit Format"),
                KDialogBase::Ok|KDialogBase::Cancel|KDialogBase::Help, KDialogBase::Ok)
{
  mFormatWidget = new FormatWidget(this);
  setMainWidget(mFormatWidget);

  setFormat(format);
}

Sonik::Format FormatDialog::format() const
{
  Format format;

  if (mFormatWidget->channels1->isChecked())
    format.channels = 1;
  else if (mFormatWidget->channels2->isChecked())
    format.channels =  2;
  else if (mFormatWidget->channelsOther->isChecked())
    format.channels = mFormatWidget->channelsOtherSel->value();
  else
    format.channels = 0;

  QString text = mFormatWidget->rate->currentText();
  bool ok;
  format.sampleRate = text.left(text.find(" Hz")).toInt(&ok);
  if (!ok)
    format.sampleRate = 1;

  if (mFormatWidget->res8bit->isChecked())
    format.bits = 8;
  else if (mFormatWidget->res16bit->isChecked())
    format.bits = 16;
  else if (mFormatWidget->res24bit->isChecked())
    format.bits = 24;
  else
    format.bits = 0;

  kdDebug(60606) << "FormatDialog::format: "
                 << format
                 << "\n";

  return format;
}

void FormatDialog::setFormat(const Format& format)
{
  if (format.channels == 1)
    mFormatWidget->channels1->setChecked(true);
  else if (format.channels == 2)
    mFormatWidget->channels2->setChecked(true);
  else
  {
    mFormatWidget->channelsOther->setChecked(true);
    mFormatWidget->channelsOtherSel->setEnabled(true);
    mFormatWidget->channelsOtherSel->setValue(format.channels);
  }

  mFormatWidget->rate->setCurrentText(QString("%1 Hz").arg(format.sampleRate));

  assert(format.bits == 8 || format.bits == 16 || format.bits == 24);

  if (format.bits == 8)
    mFormatWidget->res8bit->setChecked(true);
  else if (format.bits == 16)
    mFormatWidget->res16bit->setChecked(true);
  else if (format.bits == 24)
    mFormatWidget->res24bit->setChecked(true);
}
