/*
 *
 *    soniK digital audio editor
 *    Copyright (C) 2003-2006  Robert Walker <rob@tenfoot.org.uk>
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#ifndef SONIK_PLUGIN_H
#define SONIK_PLUGIN_H

#include <kparts/plugin.h>

#include <qstring.h>

class QWidget;

namespace Sonik
{
  class Plugin : public KParts::Plugin
  {
    Q_OBJECT
  public:
    Plugin(const QString& pluginName, const QString& displayName,
           QObject* parent=0, const char* name=0,
           const QStringList& args=QStringList());
    virtual ~Plugin()                                                   = 0;

    QString pluginName(void)  const { return mPluginName; }
    QString displayName(void) const { return mDisplayName; }

    virtual QWidget* makeConfigPage(QWidget* parent=0)                  = 0;
    virtual void     applyConfigPage()                                  = 0;

  protected:
    QString mPluginName;
    QString mDisplayName;
  };

  typedef QValueList<Plugin*>        PluginList;
}

#endif // SONIK_PLUGIN_H
