/*
 *
 *    soniK digital audio editor
 *    Copyright (C) 2003-2006  Robert Walker <rob@tenfoot.org.uk>
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#ifndef SONIK_RECORD_DIALOG_H
#define SONIK_RECORD_DIALOG_H

#include "recorddialogbase.h"
#include "sonik_types.h"

namespace Sonik
{
  class Part;

  class RecordDialog : public RecordDialogBase
  {
    Q_OBJECT
  public:
    RecordDialog(Part& part,
                 QWidget *parent=0, const char *name=0,
                 bool modal=FALSE, WFlags fl=0);
    virtual ~RecordDialog();

    InsertPosition action() const;
    const Format& format() const;

  public slots:
    void position(off_t pos);
    void timeFormatChanged(Sonik::TimeFormat fmt);
    void selectionChanged(off_t start, size_t length);

  protected slots:
    void actionChanged();
    void recordClicked();

    void formatClicked();

    void recording();
    void stopped();

  signals:
    void record();
    void stop();
    void finished();

  protected:
    virtual void hideEvent(QHideEvent* event);

  private:
    void setFormatLabel();
    void updatePosition(off_t pos);

    enum State {
      Idle,                     // Idle
      PreRecord,                // Record pressed, but audio IO not started
      Recording,                // Recording
      Stopping                  // Stop pressed, but audio IO still going
    };

    Part&          mPart;
    InsertPosition mAction;
    Format         mFormat;

    State          mState;
    uint32_t       mFlashCount;
    off_t          mPosition;
  };
}


#endif // SONIK_RECORD_DIALOG_H
