/*
 *
 *    soniK digital audio editor
 *    Copyright (C) 2003-2006  Robert Walker <rob@tenfoot.org.uk>
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#undef QT_TEST

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>

#ifdef QT_TEST
#include <cppunit/ui/qt/TestRunner.h>
#else
#include <cppunit/ui/text/TestRunner.h>
#include <cppunit/TestResultCollector.h>
#endif



int main(int argc, char* argv[])
{
  // Get the top level suite from the registry
  CppUnit::Test *suite = CppUnit::TestFactoryRegistry::getRegistry().makeTest();

#ifdef QT_TEST

  CppUnit::QtUi::TestRunner runner;
  runner.addTest( suite );
  runner.run();
  return 0;

#else

  CppUnit::TextUi::TestRunner runner;
  runner.addTest( suite );

  runner.setOutputter(
    new CppUnit::CompilerOutputter(&runner.result(), std::cerr, "%p:%l:")
    );

  return runner.run() ? 0 : 1;

#endif
}
