/*
 *
 *    soniK digital audio editor
 *    Copyright (C) 2003-2006  Robert Walker <rob@tenfoot.org.uk>
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#ifndef SONIK_UI_CONTROL_H
#define SONIK_UI_CONTROL_H

#include <qobject.h>
#include <qstring.h>

namespace Sonik
{
  class UiControl : public QObject
  {
    Q_OBJECT
  public:
    enum Type { NONE, HSLIDER, VSLIDER, KNOB, SWITCH, CUSTOM };

    UiControl();
    UiControl(const QString& id, const QString& name,
              QWidget *widget, const QString& valProperty);
    UiControl(const QString& id, const QString& name, Type type,
              float val, float min, float max,
              int precision, bool log,
              QWidget* parent);
    virtual ~UiControl();

    void     setWidget(QWidget* widget, const QString& valProperty);
    QWidget* widget();

    QString id() const   { return mId; }
    QString name() const { return mName; }

    virtual float value() const;
    virtual void  setValue(float v);

    static QString typeToString(Type t);
    static Type    stringToType(const QString& s);

  private:
    QString  mId;
    QString  mName;
    QWidget* mWidget;
    QString  mValProperty;
  };

  class UiControlPtrList : public QValueList<UiControl*>
  {
  public:
    UiControlPtrList()
      : QValueList<UiControl*>() { }
    UiControlPtrList(const UiControlPtrList& l)
      : QValueList<UiControl*>(l) { }
    UiControlPtrList(const QValueList<UiControl*>& l)
      : QValueList<UiControl*>(l) { }

    UiControl* find(const QString& id) const;

    void alignAllHorizontalSliders();
  };
}

#endif // SONIK_UI_CONTROL_H
