/*
 *
 *    soniK digital audio editor
 *    Copyright (C) 2003-2006  Robert Walker <rob@tenfoot.org.uk>
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#ifndef SONIK_ARTS_PLUGIN_H
#define SONIK_ARTS_PLUGIN_H

#include "audioio.h"
#include <qwidget.h>

#include <arts/kartsdispatcher.h>
#include <arts/kartsserver.h>
#include <arts/qiomanager.h>

#include "sonikarts.h"

namespace Sonik
{
  class ArtsPlugin : public Sonik::AudioIO
  {
    Q_OBJECT
  public:
    // Arts is limited to 8 or 16 bits - so use 16
    static const long kBits = 16;

    ArtsPlugin(QObject* parent, const char* name, const QStringList& args);
    virtual ~ArtsPlugin();

    virtual QWidget* makeConfigPage(QWidget* parent=0);
    virtual void     applyConfigPage();

    virtual const ChannelCaps    channelCaps() const;
    virtual const SampleRateCaps sampleRateCaps() const;
    virtual const BitsCaps       bitsCaps() const;
    virtual size_t               blockSize() const;

    virtual IOResult open(AudioIOManager* manager,
                          uint8_t  channels,
                          uint32_t sampleRate,
                          uint8_t  bits);
    virtual void close();
    virtual void play();
    virtual void record();
    virtual void stop();

    virtual QWidget* makeOptionsPage(QWidget* parent=0,
                                     const char *name=0);
  private:
    enum State { kStopped, kPlaying, kRecording };

    KArtsDispatcher     mDispatcher;
    KArtsServer         mServer;
    ArtsPluginProducer  mOut;
    ArtsPluginReceiver  mIn;
    State               mState;
  };

  class ArtsPluginOptionsPage : public QWidget
  {
    Q_OBJECT
  public:
    ArtsPluginOptionsPage(Sonik::ArtsPlugin& p,
                          QWidget* parent=0, const char *name=0);
    virtual ~ArtsPluginOptionsPage();

  protected slots:
    void okClicked();

  private:
    Sonik::ArtsPlugin& mPlugin;
  };
}

#endif //  SONIK_ARTS_PLUGIN_H
