/*
 *
 *    soniK digital audio editor
 *    Copyright (C) 2005, 2006  Robert Walker <rob@tenfoot.org.uk>
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#include "waveoptions.h"

#include <knuminput.h>
#include <qcombobox.h>

using Sonik::WaveOptions;


WaveOptions::WaveOptions(double maxFreq, QWidget* parent, const char* name)
  : WaveOptionsBase(parent, name)
{
  // initialise KDoubleSpinBox here as designer gets the order wrong
  //   (the order is important - grrr why??)
  mAmplitude->setPrecision( 2 );
  mAmplitude->setMaxValue( 1.0 );
  mAmplitude->setLineStep( 0.1 );
  mAmplitude->setValue( 1.0 );
  mFreq->setPrecision( 2 );
  mFreq->setMaxValue( maxFreq);
  mFreq->setLineStep( 10.0 );
  mFreq->setValue( 1000.0 );

  waveChanged(mWave->currentItem());

  connect(mWave, SIGNAL(activated(int)),
          this, SLOT(waveChanged(int)));
}


void WaveOptions::waveChanged(int index)
{
  if (index == 0)
  {
    mDutyCycle->setEnabled(false);
  }
  else
  {
    mDutyCycle->setEnabled(true);
  }
}


double Sonik::WaveOptions::freq() const
{
  return mFreq->value();
}


void Sonik::WaveOptions::setFreq(double freq)
{
  mFreq->setValue(freq);
}


double Sonik::WaveOptions::dutyCycle() const
{
  return mDutyCycle->value() / 100.0;
}


void Sonik::WaveOptions::setDutyCycle(double dutyCycle)
{
  mDutyCycle->setValue((int)(dutyCycle * 100.0));
}


double Sonik::WaveOptions::amplitude() const
{
  return mAmplitude->value();
}


void Sonik::WaveOptions::setAmplitude(double amplitude)
{
  mAmplitude->setValue(amplitude);
}


int Sonik::WaveOptions::wave() const
{
  return mWave->currentItem();
}


void Sonik::WaveOptions::setWave(int wave)
{
  mWave->setCurrentItem(wave);
  waveChanged(wave);
}


