/*
 *
 *    soniK digital audio editor
 *    Copyright (C) 2005, 2006  Robert Walker <rob@tenfoot.org.uk>
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef SONIK_BASICGENERATOR_WAVEOPTIONS_H
#define SONIK_BASICGENERATOR_WAVEOPTIONS_H

#include "waveoptionsbase.h"

namespace Sonik
{
  class WaveOptions : public WaveOptionsBase
  {
    Q_OBJECT

    Q_PROPERTY( double freq READ freq WRITE setFreq );
    Q_PROPERTY( double dutyCycle READ dutyCycle WRITE setDutyCycle );
    Q_PROPERTY( double amplitude READ amplitude WRITE setAmplitude );
    Q_PROPERTY( int wave READ wave WRITE setWave );

  public:
    WaveOptions(double maxFreq, QWidget* parent=0, const char* name=0);

    double freq() const;
    void setFreq(double freq);

    double dutyCycle() const;
    void setDutyCycle(double dutyCycle);

    double amplitude() const;
    void setAmplitude(double amplitude);

    int wave() const;
    void setWave(int wave);

  protected slots:
    void waveChanged(int index);

  private:

  };

}


#endif // SONIK_BASICGENERATOR_WAVEOPTIONS_H

