/*
 *
 *    soniK digital audio editor
 *    Copyright (C) 2003-2006  Robert Walker <rob@tenfoot.org.uk>
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#ifndef SONIK_CHANNELS_DIALOGS_H
#define SONIK_CHANNELS_DIALOGS_H

#include "simplechanneldialog.h"
#include "insertchannelsdialog.h"
#include "removechannelsdialog.h"

#include "gainmatrix.h"

#include <kdialogbase.h>

namespace Sonik
{
  class Slider;

  class InsertChannelsDialog : public InsertChannelsDialogBase
  {
    Q_OBJECT
  public:
    InsertChannelsDialog(size_t inChannels,
                         QWidget* parent = 0, const char* name = 0);

    const GainMatrix& gain() const { return mGain; }

  protected slots:
    virtual void mixButtonClicked();
    virtual void recalculateGain();

  private:
    GainMatrix mGain;
  };

  class RemoveChannelsDialog : public RemoveChannelsDialogBase
  {
    Q_OBJECT
  public:
    RemoveChannelsDialog(size_t inChannels,
                         QWidget* parent = 0, const char* name = 0);

    const GainMatrix& gain() const { return mGain; }

  protected slots:
    virtual void mixButtonClicked();
    virtual void startChannelChanged(int value);
    virtual void recalculateGain();

  private:
    GainMatrix mGain;
  };

  class MonoToStereoDialog : public SimpleChannelDialogBase
  {
    Q_OBJECT
  public:
    MonoToStereoDialog(QWidget* parent = 0, const char* name = 0);

    const GainMatrix& gain() const { return mGain; }

  protected slots:
    virtual void accept();
    virtual void mixButtonClicked();

  private:
    GainMatrix mGain;
  };

  class StereoToMonoDialog : public SimpleChannelDialogBase
  {
    Q_OBJECT
  public:
    StereoToMonoDialog(QWidget* parent = 0, const char* name = 0);

    const GainMatrix& gain() const { return mGain; }

  protected slots:
    virtual void accept();
    virtual void mixButtonClicked();

  private:
    GainMatrix mGain;
  };

  class MixDialog : public KDialogBase
  {
    Q_OBJECT
  public:
    MixDialog(const GainMatrix& gain,
              QWidget* parent = 0, const char* name = 0);

    const GainMatrix& gain() const { return mGain; }

  protected slots:
    virtual void accept();

  private:
    GainMatrix mGain;

    QValueVector< QValueVector<Slider *> > mSliders;
  };
}


#endif // SONIK_CHANNELS_DIALOGS_H
