/*
 *
 *    soniK digital audio editor
 *    Copyright (C) 2003-2006  Robert Walker <rob@tenfoot.org.uk>
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#ifndef SONIK_FORMAT_PLUGIN_H
#define SONIK_FORMAT_PLUGIN_H

#include "gainmatrix.h"

#include "edit.h"

namespace Sonik
{
  class GainMatrix;

  class FormatPlugin : public Edit
  {
    Q_OBJECT
  public:
    class MixDialog;

    FormatPlugin(QObject* parent, const char* name, const QStringList& args);
    virtual ~FormatPlugin();

    virtual void init(Data* data, PartWidget* widget, ActionManager* actionManager);

    virtual QWidget* makeConfigPage(QWidget* parent=0);
    virtual void     applyConfigPage();

  protected slots:
    void uiEditFormat();
    void uiEditChannelsMono();
    void uiEditChannelsStereo();
    void uiEditChannelsInsert();
    void uiEditChannelsRemove();

    void dataChannelsChanged(uint8_t channels);

  private:
    void changeChannels(const GainMatrix& gain, const QString &label);

    KAction* mEditChannelsMono;
    KAction* mEditChannelsStereo;
  };
}


#endif // SONIK_FORMAT_PLUGIN_H
