/*
 *
 *    soniK digital audio editor
 *    Copyright (C) 2003-2006  Robert Walker <rob@tenfoot.org.uk>
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#ifndef SONIK_CHANNELS_GAINMATRIX_H
#define SONIK_CHANNELS_GAINMATRIX_H

#include <qvaluevector.h>

namespace Sonik
{
  class GainMatrix
  {
  public:
    typedef QValueVector<float> OutputGains;

    GainMatrix(size_t inChannels = 0, size_t outChannels = 0);
    virtual ~GainMatrix();

    size_t inChannels() const  { return mData.size(); }
    size_t outChannels() const { return (mData.size() > 0) ? mData[0].size() : 0; }

    void resize(size_t inChannels = 0, size_t outChannels = 0);

    const OutputGains& operator[](size_t inChannel) const
    {
      return mData[inChannel];
    }

    OutputGains& operator[](size_t inChannel)
    {
      return mData[inChannel];
    }

    void zero();

  private:
    QValueVector<OutputGains> mData;
  };
}


#endif // SONIK_CHANNELS_GAINMATRIX_H
