/*
 *
 *    soniK digital audio editor
 *    Copyright (C) 2003-2006  Robert Walker <rob@tenfoot.org.uk>
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#ifndef SONIK_SELECT_PLUGIN_H
#define SONIK_SELECT_PLUGIN_H

#include "edit.h"

namespace Sonik
{
  class SelectPlugin : public Edit
  {
    Q_OBJECT
  public:
    SelectPlugin(QObject* parent, const char* name, const QStringList& args);
    virtual ~SelectPlugin();

    virtual QWidget* makeConfigPage(QWidget* parent=0);
    virtual void     applyConfigPage();

  protected slots:
    void uiEditSelectMoveStartNextZeroCross();
    void uiEditSelectMoveStartPrevZeroCross();
    void uiEditSelectMoveEndNextZeroCross();
    void uiEditSelectMoveEndPrevZeroCross();
    void uiEditSelectMoveStartNextPeak();
    void uiEditSelectMoveStartPrevPeak();
    void uiEditSelectMoveEndNextPeak();
    void uiEditSelectMoveEndPrevPeak();

  private:
    void moveSelectionStart(off_t start);
    void moveSelectionEnd(off_t end);

    off_t findZeroCrossing(off_t p, int dir);
    off_t findPeak(off_t p, int dir);

    void getNextBlock(off_t p, int dir, SampleBuffer& buf);
  };

}


#endif // SONIK_SELECT_PLUGIN_H
