/*
 *
 *    soniK digital audio editor
 *    Copyright (C) 2003-2006  Robert Walker <rob@tenfoot.org.uk>
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#ifndef SONIK_AUDIOFILE_AFPLUGIN_H
#define SONIK_AUDIOFILE_AFPLUGIN_H

#include "fileio.h"

#include <qwidget.h>
#include <audiofile.h>

class QComboBox;

namespace Sonik
{
  class AFPlugin : public Sonik::FileIO
  {
    Q_OBJECT
  public:
    enum CompressionMode { kNone, kULaw, kALaw };

    class Reader : public Sonik::FileIO::Reader
    {
    public:
      Reader(const QString& fileName, const QString& mimeType);
      virtual ~Reader();

      virtual IOResult open();
      virtual void     close();
      virtual uint32_t read(SampleBuffer& data);

      virtual bool     optionsAvailable();
      virtual QWidget* makeOptionsPage(QWidget* parent=0, const char *name=0);

      CompressionMode compressionMode() { return mCompressionMode; }
      void setCompressionMode(CompressionMode mode) { mCompressionMode = mode; }

    private:
      AFfilehandle mHandle;
      uint         mFrameSize;
      int          mSampleFormat;
      uint         mPos;

      // user parameters
      CompressionMode  mCompressionMode;
    };

    class Writer : public Sonik::FileIO::Writer
    {
    public:
      Writer(const QString& fileName, const QString& mimeType,
             size_t length, uint8_t channels,
             uint32_t sampleRate, uint8_t bits);
      virtual ~Writer();

      virtual IOResult open();
      virtual void     close();
      virtual uint32_t write(const SampleBuffer& data);

      virtual bool     optionsAvailable();
      virtual QWidget* makeOptionsPage(QWidget* parent=0, const char *name=0);

      CompressionMode compressionMode() { return mCompressionMode; }
      void setCompressionMode(CompressionMode mode) { mCompressionMode = mode; }

    private:
      AFfilehandle mHandle;
      uint         mFrameSize;
      int          mSampleFormat;
      uint         mPos;

      // user parameters
      CompressionMode  mCompressionMode;
    };


    AFPlugin(QObject* parent, const char* name, const QStringList& args);
    virtual ~AFPlugin();

    virtual QWidget* makeConfigPage(QWidget* parent=0);
    virtual void     applyConfigPage();

    virtual FileIO::Reader* makeReader(const QString& fileName,
                                       const QString& mimeType) const;
    virtual FileIO::Writer* makeWriter(const QString& fileName,
                                       const QString& mimeType,
                                       size_t length, uint8_t channels,
                                       uint32_t sampleRate, uint8_t bits) const;
  private:
  };

  class AFWriteOptionsPage : virtual public QWidget
  {
    Q_OBJECT
  public:
    AFWriteOptionsPage(AFPlugin::Writer& w,
                       QWidget* parent=0, const char *name=0);
    virtual ~AFWriteOptionsPage();

  protected slots:
    void okClicked();

  private:
    AFPlugin::Writer& mWriter;
    QComboBox*        mCompressionMode;
  };

}

#endif // SONIK_AUDIOFILE_PLUGIN_H
