#!/bin/sh

DEBUGGER=$1
shift

if [ "$DEBUGGER" = "kdbg" ]; then
  SHL_DISABLE="#"
fi

if [ "$KDE_LIBSRC" ]; then
  cat <<EOF
dir $KDE_LIBSRC/kdecore
dir $KDE_LIBSRC/kdeui
dir $KDE_LIBSRC/kparts
EOF
fi

cat <<EOF
file $SONIK_DEST/bin/sonik

set environment SONIK_GDB=yes
$SHL_DISABLE set auto-solib-add off
set args --nofork --nocrashhandler "$@"

define sonik-shared
  shared .*sonik.*
end

define kde-shared
  shared .*kde.*
  shared .*kparts.*
end

dir $SONIK_SRC
dir $SONIK_BUILD

$SHL_DISABLE tbreak $SONIK_SRC/app/main.cpp:59
run
$SHL_DISABLE sonik-shared

EOF
