#
# spec file for soniK RPM packages
#
#    Copyright (C) 2003-2006  Robert Walker <rob@tenfoot.org.uk>
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
#
# based on example RPM spec from kmymoney (http://kmymoney2.sourceforge.net)
#

%define is_mandrake %(test -e /etc/mandrake-release && echo 1 || echo 0)
%define is_suse %(test -e /etc/SuSE-release && echo 1 || echo 0)
%define is_fedora %(test -e /etc/fedora-release && echo 1 || echo 0)

%define dist redhat
%define disttag rh
%define kde_path /usr

%if %is_mandrake
%define dist mandrake
%define disttag mdk
%endif
%if %is_suse
%define dist suse
%define disttag suse
%define kde_path /opt/kde3
%endif
%if %is_fedora
%define dist fedora
%define disttag fc
%endif

%define _bindir         %kde_path/bin
%define _datadir        %kde_path/share
%define _iconsdir       %_datadir/icons
%define _docdir         %_datadir/doc
%define _localedir      %_datadir/locale
%define qt_path         /usr/lib/qt3

%define distver %(release="`rpm -q --queryformat='%{VERSION}' %{dist}-release 2> /dev/null | tr . : | sed s/://g`" ; if test $? != 0 ; then release="" ; fi ; echo "$release")
%define distlibsuffix %(%_bindir/kde-config --libsuffix 2>/dev/null)
%define _lib lib%distlibsuffix
%define packer %(finger -lp `echo "$USER"` | head -n 1 | cut -d: -f 3)

Name:      sonik
Summary:   soniK Digital Audio Editor
Version:   1.0.0
Release:   1.%{disttag}%{distver}
License:   GPL
Vendor:    Rob Walker <rob@tenfoot.org.uk>
Group:     Applications/Multimedia
Source0:   %name-%version.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-build
BuildRequires: kdelibs-devel, gsl-devel, audiofile-devel, ladspa-devel, liblrdf-devel, raptor-devel

%description

soniK is an open source digital audio editor for Linux, using the KDE
platform.  soniK allows you to record, edit and process sounds on your
computer.

soniK's main features include:
* Record & play audio using your computer's soundcard
* Visualise the audio as a waveform or a spectrogram
* Edit the audio and transform it with a wide variety of plugins
* Generate new sounds
* Develop your own plugins using the soniK SDK


%package devel
Requires: sonik
Summary: soniK development files
Group: Applications/Multimedia
Provides: sonik-devel

%description devel

soniK is an open source digital audio editor for Linux, using the KDE
platform.  soniK allows you to record, edit and process sounds on your
computer.

This package provides the SDK (headers and libraries) to develop custom
plugins


%prep
#echo %_target
#echo %_target_alias
#echo %_target_cpu
#echo %_target_os
#echo %_target_vendor
echo Building %{name}-%{version}-%{release}
%setup -q -n %{name}-%{version}

%build
CFLAGS="%optflags" CXXFLAGS="%{optflags}" \
       ./configure --mandir=%{_mandir}\
                   --disable-rpath \
                   --enable-final

#make

%install
make DESTDIR=%buildroot install
# install man page
mkdir -p %buildroot%_mandir/man1
gzip -9 -c sonik.1 > %buildroot%_mandir/man1/sonik.1.gz

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -rf ${RPM_BUILD_ROOT}

%post
cd %_docdir/HTML/*/%{name}
ln -s ../common common
/sbin/ldconfig

%postun
/sbin/ldconfig

%files
%defattr(-,root,root)

# docs

%dir %_docdir/HTML/en/%{name}/
%doc %_docdir/HTML/*/%{name}/common
%doc %_docdir/HTML/*/%{name}/*.docbook
%doc %_docdir/HTML/*/%{name}/*.png
%doc %_docdir/HTML/*/%{name}/index.cache.bz2
%doc %_mandir/man1/sonik.1.gz

# the binary files
%{_bindir}/%{name}

# the shared libraries
%kde_path/%_lib/libsonikbase.so.0.0.0
%kde_path/%_lib/libsonikbase.so.0
%kde_path/%_lib/kde3/libsonik_artsaudio.la
%kde_path/%_lib/kde3/libsonik_artsaudio.so
%kde_path/%_lib/kde3/libsonik_audiofile.la
%kde_path/%_lib/kde3/libsonik_audiofile.so
%kde_path/%_lib/kde3/libsonik_displaynormal.la
%kde_path/%_lib/kde3/libsonik_displaynormal.so
%kde_path/%_lib/kde3/libsonik_displayspectral.la
%kde_path/%_lib/kde3/libsonik_displayspectral.so
%kde_path/%_lib/kde3/libsonik_editamplify.la
%kde_path/%_lib/kde3/libsonik_editamplify.so
%kde_path/%_lib/kde3/libsonik_editbasicgenerator.la
%kde_path/%_lib/kde3/libsonik_editbasicgenerator.so
%kde_path/%_lib/kde3/libsonik_editformat.la
%kde_path/%_lib/kde3/libsonik_editformat.so
%kde_path/%_lib/kde3/libsonik_editladspa.la
%kde_path/%_lib/kde3/libsonik_editladspa.so
%kde_path/%_lib/kde3/libsonik_editreverse.la
%kde_path/%_lib/kde3/libsonik_editreverse.so
%kde_path/%_lib/kde3/libsonik_editselect.la
%kde_path/%_lib/kde3/libsonik_editselect.so
%kde_path/%_lib/kde3/libsonikpart.la
%kde_path/%_lib/kde3/libsonikpart.so

# UI rc files
%_datadir/apps/sonik/sonikui.rc
%_datadir/apps/sonikpart/sonikpartui.rc

# icons
%_datadir/apps/sonikpart/icons/*/*/*/*.png
%_datadir/apps/sonikpart/icons/*/*/*/*.svg
%_iconsdir/*/*/*/*.png
%_iconsdir/*/*/*/*.svg

# desktop files
%_datadir/applications/kde/sonik.desktop
%_datadir/services/*

# plugin defs
%_datadir/apps/sonikpart/kpartplugins/audio_arts.rc
%_datadir/apps/sonikpart/kpartplugins/display_normal.rc
%_datadir/apps/sonikpart/kpartplugins/display_spectral.rc
%_datadir/apps/sonikpart/kpartplugins/edit_amplify.rc
%_datadir/apps/sonikpart/kpartplugins/edit_basicgenerator.rc
%_datadir/apps/sonikpart/kpartplugins/edit_format.rc
%_datadir/apps/sonikpart/kpartplugins/edit_ladspa.rc
%_datadir/apps/sonikpart/kpartplugins/edit_reverse.rc
%_datadir/apps/sonikpart/kpartplugins/edit_select.rc
%_datadir/apps/sonikpart/kpartplugins/file_audiofile.rc

# presets
%_datadir/apps/sonikpart/presets/*

# plugin info
%_datadir/apps/sonikpart/ladspaplugins/*

#
#
# %_localedir/*/*/*.mo

%files devel
%kde_path/include/sonik/*
%kde_path/%_lib/libsonikbase.la
%kde_path/%_lib/libsonikbase.so
%kde_path/%_lib/pkgconfig/sonik.pc
# plugin libs

%changelog

* Tue May 30 2006 - rob@tenfoot.org.uk
- New upstream release

* Sun Apr 23 2006 - rob@tenfoot.org.uk
- New upstream release

* Sat Feb 11 2006 - rob@tenfoot.org.uk
- Merge ladspa plugin package into main package

* Wed Jan 25 2006 - rob@tenfoot.org.uk
- New upstream release

* Thu Dec 8 2005 - rob@tenfoot.org.uk
- Initial implementation
