/*
 *
 *    soniK digital audio editor
 *    Copyright (C) 2003-2006  Robert Walker <rob@tenfoot.org.uk>
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#ifndef SONIK_COMPLEX_TEST_H
#define SONIK_COMPLEX_TEST_H

#include "test.h"

#include "sonik_complex.h"

#include <cppunit/TestAssert.h>
#include <sstream>

template <>
inline void _checkDataEq(const char *pos,
                         const Sonik::ComplexSample* buf1, size_t len1,
                         const Sonik::ComplexSample* buf2, size_t len2)
{
  CPPUNIT_ASSERT_EQUAL(len1, len2);

  for (size_t i = 0; i < len1; ++i)
  {
    float ar = buf1[i].real, ai = buf1[i].imag,
      br = buf2[i].real, bi = buf2[i].imag,
      er = EPSILON, ei = EPSILON;

    // scale EPSILON for large numbers
    if (br > 1.0)
      er = std::fabs(er * br);
    if (bi > 1.0)
      ei = std::fabs(ei * bi);

    if (std::fabs(ar - br) > er ||
        std::fabs(ai - bi) > ei)
    {
      std::ostringstream msg;
      msg << "\n" << pos << ": buffer compare"
          << " (" << buf1[i].real << "+" << buf1[i].imag << "i "
          << "== " << buf2[i].real << "+" << buf2[i].imag << ")"
          << " at i = " << i
          << "\n";

      CPPUNIT_FAIL(msg.str().c_str());
    }
  }
}

#endif // SONIK_COMPLEX_TEST_H
