#    soniK digital audio editor
#    Copyright (C) 2003-2004, 2006  Robert Walker <rob@tenfoot.org.uk>
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

OK=yes

rand()
{
  perl -e "print ($1 + int(($2 - $1 + 1) * rand()))"
}

chkout()
{
  diff -u -1 $1 $2
}

fail()
{
  echo "FAIL: $*"
  OK=no
}

pass()
{
  echo "PASS: $*"
}

report()
{
  if [ $? -ne 0 ]; then
    fail $*
  else
    pass $*
  fi
}

gen_sizes()
{
  SIZE_MAX=$2
  i=$1
  while [ ${i} -le ${SIZE_MAX} ]; do
    echo ${i}
    i=$(( ${i} * 2 ))
  done
  i=0
  while [ ${i} -lt $3 ]; do
    r=`rand 2 ${SIZE_MAX}`
    echo ${r}
    i=$(( ${i} + 1 ))
  done
}

endTest()
{
  if [ "$OK" = "yes" ]; then
    exit 0
  else
    exit 1
  fi
}
