#!/usr/bin/perl -w
#
# a very simple install script
# start it with
#   ./install.pl
# to install StreamDVD Gui
#
# see README for further instructions

my @pm_list = ("Calc.pm","Config.pm","Defs.pm","Gui.pm","Project.pm","Title.pm","Util.pm","Streams.pm");
my @bin_list = ("StreamDVD.pl");

my $inst_pm = `perl '-V:installsitelib'`;
$inst_pm =~ s/.*='(\S+)';/$1/;
chomp $inst_pm;

my $inst_bin = `perl '-V:installsitebin'`;
$inst_bin =~ s/.*='(\S+)';/$1/;
chomp $inst_bin;


print("Looking for needed modules ... ");
require Tk;
require Tk::BrowseEntry;
require Tk::Photo;
require Tk::JPEG::Lite;
use File::Copy;
print("done\n\n");


print("Copying files ... ");
if( not -d $inst_pm."/StreamDVD" ) {
   if( not mkdir $inst_pm."/StreamDVD" ) {
      print("failed: cannot create dir $inst_pm/StreamDVD\n\n");
      exit(1);
   }
}
for my $m (@pm_list) {
   copy("StreamDVD/".$m, $inst_pm."/StreamDVD/".$m); }
for my $m (@bin_list) {
   copy($m, $inst_bin."/".$m); 
   system("chmod 755 $inst_bin/$m");
}
print("done\n\n");


