#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "libpcm.h"

// small library for reading pcm files
/*****************************************************************************
*
*  Routines to determine byte order and swap bytes
*
*****************************************************************************/


short int *inputbuffer;

enum byte_order DetermineByteOrder (void)
{
  char s[sizeof (long) + 1];
  union {
    long longval;
    char charval[sizeof (long)];
  } probe;
  probe.longval = 0x41424344L;	/* ABCD in ASCII */
  strncpy (s, probe.charval, sizeof (long));
  s[sizeof (long)] = '\0';
  /* fprintf( stderr, "byte order is %s\n", s ); */
  if (strcmp (s, "ABCD") == 0)
    return order_bigEndian;
  else if (strcmp (s, "DCBA") == 0)
    return order_littleEndian;
  else
    return order_unknown;
}

void SwapBytesInWords (short *loc, int words)
{
  int i;
  short thisval;
  char *dst, *src;
  src = (char *) &thisval;
  for (i = 0; i < words; i++) {
    thisval = *loc;
    dst = (char *) loc++;
    dst[0] = src[1];
    dst[1] = src[0];
  }
}

int pcm_get_audio (sound_info_t *sound_info, short int *pcmaudio[2], int numSamples)
{
  int j;
  int samples_read;
  FILE *musicin = sound_info->soundfile;
  int numChannels = sound_info->numChannels;
  static int init=0;

  // Always allocate for stereo. Does it really matter? MFC May 03
  if (!init) {
    init++;
    inputbuffer = (short int *)calloc(2*numSamples, sizeof(short int *));
  }

  if (numChannels == 2) {		/* stereo */
    samples_read = fread (inputbuffer, sizeof(short int), 2*numSamples, musicin);
    samples_read /= 2;
    for (j = 0; j < samples_read; j++) {
      pcmaudio[0][j] = inputbuffer[2 * j];
      pcmaudio[1][j] = inputbuffer[2 * j + 1];
    }
    if (sound_info->byteswap) {
      SwapBytesInWords (pcmaudio[0], samples_read);
      SwapBytesInWords (pcmaudio[1], samples_read);
    }
      
  } else {
    // Mono. just read straight into the buffer
    samples_read = fread (pcmaudio[0], sizeof(short int), numSamples, musicin);
    if (sound_info->byteswap) {
      SwapBytesInWords(pcmaudio[0], samples_read);
    }
  }
  return (samples_read);
}

sound_info_t *pcm_init(char *filename, int numChannels, double sampleRate) {
  
  sound_info_t *sound_info;
  FILE *soundfile;

  if ( (soundfile = fopen(filename, "r")) == NULL) {
    fprintf(stderr, "PCM: Can't open file\n");
    return(NULL);
  }

  sound_info = (sound_info_t *)calloc(1, sizeof(sound_info_t));
  sound_info->soundfile = soundfile;
  sound_info->numChannels = numChannels;
  sound_info->sampleRate = sampleRate;
  sound_info->numSamples = -1; // UNKNOWN. i suppose you could
                               // stat the file and have a guess. MFC May 03.

  return(sound_info);
}

/* Free the memory associated with the input buffer */
void pcm_deinit() {
  if (inputbuffer != NULL)
    free(inputbuffer);
}
