typedef struct sound_info_struct
{
  FILE *soundfile;
  short numChannels; // 1 - mono . 2 - stereo. d'uh.
  unsigned long numSamples; //total number of samples/channel if available
  short sampleSize; //8 bit or 16bit. could probably just auto scale. but i think
                    // we'll just ignore 8bit sound. MFC May03
  int sampleRate; // in Hz
  unsigned long sampleType; //left over from AIFF spec. delete? MFC May03
  int byteswap;
}
sound_info_t;

enum byte_order { order_unknown, order_bigEndian, order_littleEndian };

sound_info_t *pcm_init(char *filename, int numChannels, double sampleRate);
void pcm_deinit(void);
int pcm_get_audio (sound_info_t *sound_info, short int *pcmaudio[2], int numSamples);


void SwapBytesInWords (short *loc, int words);
enum byte_order DetermineByteOrder (void);
