#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "libpcm.h"
#include "libwave.h"
#include "../libtoolame/toolame.h"

#define MP2BUFSIZE 16384
#define AUDIOBUFSIZE 8192

void usage (void) {			       
  fprintf(stdout,"stoolame <input wavefile> <output mp2 file>\n");
  exit (1);
}

int main (int argc, char **argv) {
  toolame_options *encodeOptions;
  char inputfilename[256], outputfilename[256];
  int i;
  FILE *outfile;
  short int *pcmaudio[2];
  int num_samples;
  int frames=0;
  unsigned char mp2buffer[MP2BUFSIZE];
  int mp2buffer_size = MP2BUFSIZE;
  int mp2fill_size;
  sound_info_t *sound_info = NULL;
  int audioReadSize = AUDIOBUFSIZE; 

  if (argc != 3) 
    usage();

  strcpy(inputfilename, argv[1]);
  strcpy(outputfilename, argv[2]);

  /* Allocate some space for the PCM audio data */
  for (i=0;i<2;i++)
    if ( (pcmaudio[i]=(short int *)calloc(AUDIOBUFSIZE, sizeof(short int)))==NULL) {
      fprintf(stdout,"pcmaudio %i alloc failed\n", i);
      exit(99);
    }

  /* grab a set of default encode options */
  encodeOptions = toolame_init();

  if ( (sound_info = wave_init(inputfilename)) == NULL ) {
    fprintf(stdout,"Not a recognised WAV file\n");
    exit(99);
  }

  // Use sound file to over-ride preferences for
  // mono/stereo and sampling-frequency
  if (sound_info->numChannels == 1) 
    toolame_setMode(encodeOptions, MPG_MD_MONO);
  toolame_setSampleFreq(encodeOptions, sound_info->sampleRate);
  
  /* initialise toolame with this set of options */
  toolame_init_params(encodeOptions);

  /* Open the output file for the encoded MP2 data */
  if ((outfile = fopen(outputfilename, "w"))==0) {
    fprintf(stdout,"output file error opening %s\n",outputfilename);
    exit(99);
  }
  
  /* Now do the buffering/encoding/writing */
  while ( (num_samples = pcm_get_audio(sound_info, pcmaudio, audioReadSize)) != 0 ) { 
    // Read num_samples of  audio data *per channel* from the input file
    frames += toolame_encode_buffer(encodeOptions, pcmaudio[0], pcmaudio[1], num_samples, mp2buffer, mp2buffer_size, &mp2fill_size);
    fwrite(mp2buffer, sizeof(unsigned char), mp2fill_size, outfile);
    fprintf(stdout,"[%04i]\r", frames);
    fflush(stdout);
  }
  
  /* flush any remaining audio. (don't send any new audio data)
     There should only ever be a max of 1 frame on a flush.
     There may be zero frames if the audio data was an exact
     multiple of 1152 */
  toolame_encode_flush(encodeOptions, mp2buffer, mp2buffer_size, &mp2fill_size);

  fwrite(mp2buffer, sizeof(unsigned char), mp2fill_size, outfile);

  toolame_deinit(encodeOptions);
  fprintf(stdout,"Finished nicely\n");
  return(0);
}
