#ifndef _TRANSKODE_APPLICATION_H_
#define _TRANSKODE_APPLICATION_H_

/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include <logger.h>

#include <filejob.h>
#include <jobqueue.h>
#include <worker.h>

#include <configdialog.h>
#include "stdinlistener.h"

#include <kapplication.h>

namespace TransKode
{
	class Application: public KApplication
	{
		Q_OBJECT

		public:

			Application();
			virtual ~Application();

		public slots:
			void addTransferToMediaDeviceJob( const QString& url, const QString& extension );
			void addTranscodeJobs( const QStringList& urls, const QString& profile );

		protected slots:
			void slotPreferences();
			void slotConfig();

			/*void displayStreamRipStarted( long workerID, int jobID, const QString& URL );
			void displayStreamRipFinished( long workerID, int jobID, const QString& URL, const QStringList& rippedFiles );*/

			void displayJobStarted( long jobID, const QString& dstPath, const QString& srcPath );
			void displayJobError( long jobID, const QString& errorMsg, const QString& srcPath );

			void displayRoundStats( long workerID, int okCount, int errorCount, int cancelledCount );

			void amarokSuccess( long jobID, const QString& dstPath, const QString& srcPath );
			void amarokError( long jobID, const QString& errorMsg, const QString& srcPath );
			void amarokDone();

			void displayPopup( const QString& text );

			void deleteJob( long jobID );

		protected:
			typedef enum { add, remove } TAction;

			static void cleanUp( int ); // SIGTERM handler
			void setupMenuEntries( TAction action );

		protected:
			StdinListener m_listener;

			Logger& m_logger;
			AppConfig m_config;
			ConfigDialog m_configDialog;

			JobQueue m_commonQueue;
			JobQueue m_amarokQueue;

			QPtrList<FileJob> m_jobs;

	};
}

#endif
