/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include "application.h"
#include <taglibplugins.h>

#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>

static const char description[] = I18N_NOOP( "transKode Amarok Script" );
static const char version[]		= "0.7beta";

int main( int argc, char ** argv )
{
	KAboutData about(	"transKode", 						// appName
						I18N_NOOP( "transKode" ), 			// programName
						version,							// version
						description,						// shortDescription
						KAboutData::License_GPL,			// licenseType
						"(C) 2005-2007 Sergio Pistone",		// copyrightStatement
						0, 0,								// text, homePageAddress
						"sergio_pistone@yahoo.com.ar" );	// bugsEmailAddress

	about.addAuthor( "Sergio Pistone", I18N_NOOP( "Author & mantainer" ), "sergio_pistone@yahoo.com.ar" );
	KCmdLineArgs::init( argc, argv, &about );

	TransKode::TagLibPlugins::registerFileTypeResolvers();

	TransKode::Application app;
	return app.exec();
}

