/*
 * Copyright (C) 2005 by Ian Monroe <ian@monroe.nu>
 * Released under GPL 2 or later, see COPYING
 */

/*
 * Modified by Sergio Pistone <sergio_pistone@yahoo.com.ar>
 */

#include "stdinlistener.h"
#include <qregexp.h>

StdinListener::StdinListener( QObject* parent, const char* name )
	:QObject( parent, name )
{
	listener = new QSocketNotifier( 0, QSocketNotifier::Read, 0, "StdinListener" );
	connect( listener, SIGNAL( activated(int) ), this, SLOT( parseInput() ) );
}

StdinListener::~StdinListener()
{
	if ( listener )
		delete listener;
}

void StdinListener::parseInput()
{
	//seperate stdin pointer necesary for OS X for reasons unknown
	FILE* stdinPtr = stdin;

	QString message;
	QTextIStream inputStream( stdinPtr );

	// Works for now because input messages are received one line at the time
	message = inputStream.readLine();

	if ( message == "configure" )
		emit configureRequested();
	else if ( message.left( strlen("customMenuClicked: transKode ") ) == "customMenuClicked: transKode " )
	{
		// message is: customMenuClicked: transKode [ <profile> ] <input_url1> <input_url2>...

		QRegExp profileRegExp( "customMenuClicked: transKode \\[ (.*) \\] " );
		profileRegExp.search( message );
		QString profile = profileRegExp.cap( 1 );

		QStringList urls = QStringList::split(
			" ",
			message.mid( strlen( "customMenuClicked: transKode [  ] " ) + profile.length() )
		);

		emit transcodeRequested( urls, profile );
	}
	else if ( message.left( strlen( "transcode " ) ) == "transcode " ) // Amarok transfer to media device request
	{
		// message is: transcode <input_url> <output_extension>

		QStringList tokens = QStringList::split( " ", message );

		emit transferToMediaDeviceRequested( tokens[1], tokens[2] );
	}
	else if ( ! message.isEmpty() )
		emit dataReceived( message );
	else
	{
		delete listener; // Delete listener to stop sending (empty) messages
		listener = 0;
		emit communicationClosed();
	}
}
